#include <stddef.h>
#include <string.h>
#include "config.h"

#ifndef HAVE_EXPLICIT_BZERO

#include "fetchmail.h"
#include <signal.h>

void explicit_bzero(void *buf, size_t sz)
{
    // try language standard implementations first
    // memset_explicit() is C23
    //
    // memset_s isn't widely available and not worth bothering
    //
    // actually the system feature test should have been covered
    // by fetchmail.h, and we should only be here as a fallback,
    // but just in case someone calls this legacy name directly...
# ifdef HAVE_MEMSET_EXPLICIT
    memset_explicit(buf, 0, sz);
# else
    // fallback implementation
    if (NULL == buf && 0 == sz) return;
    volatile char *p = buf;
    while(sz--) {
	*p++ = '\0';
    }
# endif
}
#endif
